sub simmatch{
  my($w1,$w2,$type,$winner,$finish);
  $w1 = shift(@_);
  $w2 = shift(@_);
  $type = shift(@_);
  $winner = shift(@_);
  $finish = shift(@_);
  $w1score = 0;
  $w2score = 0;

  print "$roster{$w1}[$c_name] Vs. $roster{$w2}[$c_name]\n";
  print "$mtypes[$type]\n";

  if($winner eq $w1){
    $loser = $w2;
    print "Booking Decission\n";
    print "Winner: $roster{$w1}[$c_name]\n";
    print "Scheduled Finish: $finishes[$finish]\n\n";
    match($w1,$w2,$finish);
  }
  if($winner eq $w2){
    $loser = $w1;
    print "Booking Decission\n";
    print "Winner: $roster{$w2}[$c_name]\n";
    print "Scheduled Finish: $finishes[$finish]\n\n";
    match($w2,$w1,$finish);
  }   
  if($winner eq 'sim'){
    while($w1score == $w2score){
     $w1score = getscore($w1,$w2);
     $w2score = getscore($w2,$w1);
    }

    if($w1score > $w2score){$winner = $w1;$loser = $w2;}else{$winner = $w2;$loser = $w1;}
    print "$roster{$w1}[$c_name] scored: $w1score\n";
    print "$roster{$w2}[$c_name] scored: $w2score\n";
    print "Winner: $roster{$winner}[$c_name]\n";
    print "Scheduled Finish: $finishes[$finish]\n\n";
    match($winner,$loser,$finish);
  }
  if($finish < 6){ 
    push(@winners,$winner);
    push(@losers,$loser);
  }
}

sub getscore{
  my($w1,$w2,$score);
  $w1 = shift(@_);
  $w2 = shift(@_);

  $score = 0;
  if($roster{$w1}[$c_str] > $roster{$w2}[$c_str]){$score+=2;}
  if($roster{$w1}[$c_spe] > $roster{$w2}[$c_spe]){$score++;}
  if($roster{$w1}[$c_vit] > $roster{$w2}[$c_vit]){$score++;}
  if(rand($roster{$w1}[$c_cha]) > rand($roster{$w2}[$c_cha])){$score+=2;}
  if($roster{$w1}[$c_style] == 0 and $roster{$w2}[$c_style] == 2){$score++;}
  if($roster{$w1}[$c_style] == 1 and $roster{$w2}[$c_style] == 0){$score++;}
  if($roster{$w1}[$c_style] == 2 and $roster{$w2}[$c_style] == 1){$score++;}

  return $score;
}

sub ch{
  return int(rand(2));
}

#MATCH OPTION FUNCTIONS
sub match{
  my($w1,$w2,$finish);
  $w1 = shift(@_);
  $w2 = shift(@_);
  $refbump = 0;
  $escapefinish = 0;
  $finish = shift(@_);
  if($finish == 0){
   $finish = int(rand(5)) + 1;
  }

  $continue = 1;
  $time = 0;
  while($continue){
    $continue = wrestling($w1,$w2,$finish);

    if(@match > 10){
      while(@match>10){
        $line = shift(@match);
      }
    }
  }

  $size = @match;
  print "(Match Joined in progress)\n";
  for($x=0;$x<$size;$x++){
      $line = shift(@match);
      print "$line ";
  }

  $min = int(rand(6)+4);
  $sec = int(rand(60));

  if($finish == 1){print "$roster{$w2}[$c_name] has been pinned. ";}
  if($finish == 2){print "$roster{$w2}[$c_name] lost by submission. ";}
  if($finish == 3){print "$roster{$w2}[$c_name] lost after $roster{$w1}[$c_name]'s finisher. ";}
  if($finish == 4){print "$roster{$w2}[$c_name] has been disqualified. ";}
  if($finish == 5){print "$roster{$w2}[$c_name] has been counted out. ";}
  if($finish == 6){print "The Referee calls for the bell and rules the match a double countout. ";}
  if($finish == 7){print "The Referee calls for the bell and rules the match a double disqualification. ";}
  print "\nMatch Length: $min minutes and $sec seconds";
  print "\n\n";
  
}

sub wrestling{
  my($w1,$w2,$finish);
  $w1 = shift(@_);
  $w2 = shift(@_);
  $finish = shift(@_);

  push(@match,"...");  
  if(ch() and $refbump == 0){ #ref bump 
    refbump($w1,$w2);
    $refbump = 1;
    if(ch()){ #w1 cheats
      leavering($w1,$w2);
      ringside($w2,$w1);
      returntoring($w2,'');
      $weap1 = weapon($w1,$w2);
      returntoring($w1,$weap1);
      useweapon($w1,$w2,$weap1);
      if(ch() and ($finish==1 or $finish==3)){#w1 cheated to win
        refunbump($w1,$w2);
        if($finish == 1){  
          pin($w1,$w2);
          count($w1,$w2,1,3);
        }else{
          finisher($w1,$w2);
        }
        push(@match,"$roster{$w1}[$c_name] used the $weap1 to win but the referee didn't see it.");
        return 0;
      }else{#w2 comes back
        comeback($w2);
        refunbump($w1,$w2);
        return 1;
      }
    }else{#w1 does not cheat
      pin($w1,$w2);
      push(@match,"The referee is down, there is no one to make the count.");
      refunbump($w1,$w2);      
    }
  }else{ #NO ref bump
    if(ch()){ #leave ring
      leavering($w1,$w2);
      if(ch() and $finish==6){#count out
        ringside($w1,$w2);
        count($w1,$w2,3,6);
        ringside($w1,$w2);
        count($w1,$w2,8,10);
        return 0;
      }else{
        if(ch()){#w1 gets a weapon
          $weap1 = weapon($w1,$w2);
          if(ch() and $finish==7){ #double DQ
            $weap2 = weapon($w2,$w1);
            useweapon($w1,$w2,$weap1);
            useweapon($w2,$w1,$weap2);
            return 0;
          }else{ #not a double DQ
            useweapon($w1,$w2,$weap1);
            returntoring($w1,'');
            push(@match,"$roster{$w2}[$c_name] is being counted out.");
            if(ch() and $finish==5){ #w2 is counted out
              count($w1,$w2,3,6);
              push(@match,".....");
              count($w1,$w2,8,10);
              return 0;
            }else{ #w2 makes it back to the ring
              comeback($w2);
              returntoring($w2,'');
              return 1;
            }
          }
        }else{ #w1 did not get a weapon
          if(ch()){ #w2 grabs a weapon
            $weap2 = weapon($w2,$w1);
            if(ch() and $finish==4){#W2 is DQd
              returntoring($w2,$weap2);
              return 0;
            }else{ #w2 is not DQd
              returntoring($w2,'');
              return 1;
            }
          }else{ #w2 did not grab a weapon
            ringside($w1,$w2);
            ringside($w2,$w1);
            returntoring($w1,'');
            returntoring($w2,'');
            return 1;
          }
        }
      }
    }else{ #stay in ring
      if($escapefinish == 0){
        if(ch() and $finish==3){ #w1 gets the finisher
          finisher($w1,$w2);
          return 0;
        }else{ #w2 escapes w1s finisher
          if($finish!=3){
            $escapefinish=1;
          }
          finisher($w1,$w2);
          escapefinisher($w2,$w1);
          return 1;
        }
      }else{
        if(ch() and $finish==1){
          pin($w1,$w2);
          count($w1,$w2,1,3);
          return 0;
        }
        if(ch() and $finish==2){
          submission($w1,$w2);
          push(@match,"$roster{$w2}[$c_name] taps out.");
          return 0;
        }
        pin($w1,$w2);
        count($w1,$w2,1,int(rand(3)));
        return 1;
      }
    }
  }
}

sub refbump{
  my($w1,$w2,$size,$text);
  my(@bumps) = ('w1 whips w2 into the referee. The referee goes down.',
                'w1 clotheslines w2, w2 ducks. w1 takes out the ref.',
                'w2 misses with a clothesline and takes down the referee.',
                'w1 sends w2 into the corner crushing the referee.');
  $w1 = shift(@_);
  $w2 = shift(@_);

  $size = @bumps;
  $text = $bumps[int(rand($size))];
  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  $text =~ s/w2/$roster{$w2}[$c_name]/gi;
  push(@match,$text);
}

sub leavering{
  my($w1,$w2,$size,$text);
  my(@texts) = ('w1 takes w2 out to the floor.',
                'w1 and w2 go to the floor.',
                'w1 leaves the ring and w2 follows.',
                'w2 and w1 fight to the floor.');
  $w1 = shift(@_);
  $w2 = shift(@_);

  $size = @texts;
  $text = $texts[int(rand($size))];
  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  $text =~ s/w2/$roster{$w2}[$c_name]/gi;
  push(@match,$text);
}

sub pin{
  my($w1,$w2,$size,$text);
  my(@texts) = ('w1 makes the cover on w2.',
                'w1 rolls up w2.',
                'w1 hooks the leg of w2 for a cover.',
                'w1 is able to cover w2.');
  $w1 = shift(@_);
  $w2 = shift(@_);

  $size = @texts;
  $text = $texts[int(rand($size))];
  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  $text =~ s/w2/$roster{$w2}[$c_name]/gi;
  push(@match,$text);
}

sub submission{
  my($w1,$w2,$size,$text);
  my(@texts) = ('w1 puts w2 in anklelock submission.',
                'w1 locks a chickenwing on w2.',
                'w1 rolls w2 over into a Boston crab.',
                'w1 has w2 in a figure-four leg lock.');
  $w1 = shift(@_);
  $w2 = shift(@_);

  $size = @texts;
  $text = $texts[int(rand($size))];
  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  $text =~ s/w2/$roster{$w2}[$c_name]/gi;
  push(@match,$text);
}

sub count{
  my($w1,$w2,$c1,$c2,$size,$text);
  my(@texts) = ('The referee counts ',
                'the count ');
  $w1 = shift(@_);
  $w2 = shift(@_);
  $c1 = shift(@_);
  $c2 = shift(@_);

  $size = @texts;
  $text = $texts[int(rand($size))];
  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  $text =~ s/w2/$roster{$w2}[$c_name]/gi;
  for($x=$c1;$x<$c2;$x++){
   $text = $text.$x.', ';
  }
  $text = $text.$c2;
  push(@match,$text);
}

sub refunbump{
  my($w1,$w2,$size,$text);
  my(@texts) = ('The referee has regained consisness.',
                'The referee is back to his feet.',
                'The referee recovers from that blow.',
                'The referee sees w1 and w2.');
  $w1 = shift(@_);
  $w2 = shift(@_);

  $size = @texts;
  $text = $texts[int(rand($size))];
  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  $text =~ s/w2/$roster{$w2}[$c_name]/gi;
  push(@match,$text);
}

sub ringside{
  my($w1,$w2,$size,$text);
  my(@texts) = ('w1 sends w2 into the steel steps.',
                'w2 irish whips w1 into the guard railing.',
                'w1 and w2 fight around the ring.',
                'w2 send w1 into the steel ring post.');
  $w1 = shift(@_);
  $w2 = shift(@_);

  $size = @texts;
  $text = $texts[int(rand($size))];
  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  $text =~ s/w2/$roster{$w2}[$c_name]/gi;
  push(@match,$text);
}

sub weapon{
  my($w1,$w2,$size,$text,$weap);
  my(@weapons) = ('chair',
                  'bell',
                  'steel chair',
                  'frying pan',
                  'monkey wrench');
  my(@texts) = ('w1 has gotten ahold of a weap.',
                'w1 grabs a weap.',
                'w1 now has a weap.',
                'w1 has a weap.');

  $w1 = shift(@_);
  $w2 = shift(@_);

  $size = @weapons;
  $weap = $weapons[int(rand($size))];
  
  $size = @texts;
  $text = $texts[int(rand($size))];
  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  $text =~ s/w2/$roster{$w2}[$c_name]/gi;
  $text =~ s/weap/$weap/g;
  push(@match,$text);
  return $weap;
}

sub useweapon{
  my($w1,$w2,$size,$text,$weap);
  my(@texts) = ('w1 hits w2 with the weap.',
                'w2 was hit by w1 with the weap.',
                'w1 uses that weap.',
                'w2 takes a blow from the weap.');
  $w1 = shift(@_);
  $w2 = shift(@_);
  $weap = shift(@_);

  $size = @texts;
  $text = $texts[int(rand($size))];
  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  $text =~ s/w2/$roster{$w2}[$c_name]/gi;
  $text =~ s/weap/$weap/g;
  push(@match,$text);
}

sub returntoring{
  my($w1,$size,$text,$weap);
  my(@texts) = ('w1 climbs back into the ring.',
                'w1 moves back into the ring.',
                'w1 slides into the ring.',
                'w1 returns to the ring.');
  $w1 = shift(@_);
  $weap = shift(@_);

  $size = @texts;
  $text = $texts[int(rand($size))];
  if(length($weap) > 1){
    $text = "w1 takes the $weap into the ring.";
  }
  $text =~ s/w1/$roster{$w1}[$c_name]/gi;

  push(@match,$text);
}

sub finisher{
  my($w1,$w2,$size,$text);
  my(@kos) = ('w1 executes the fin on w2.',
              'w2 takes the fin from w1.',
              'w1 delivers the fin to w2!');
  my(@subs) = ('w1 locks the fin on w2.',
               'w2 is locked in the fin!!',
               'w1 has w2 in the fin.');
  $w1 = shift(@_);
  $w2 = shift(@_);

  if($roster{$w1}[$c_mtype] == 0){ #ko
    $size = @kos;
    $text = $kos[int(rand($size))];
  }else{
    $size = @subs;
    $text = $subs[int(rand($size))];
  }

  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  $text =~ s/w2/$roster{$w2}[$c_name]/gi;
  $text =~ s/fin/$roster{$w1}[$c_move]/gi;
  push(@match,$text);

  if($roster{$w1}[$c_mtype] == 0){ #ko
    pin($w1,$w2);
    count($w1,$w2,1,3);
  }else{
    push(@match,"$roster{$w2}[$c_name] taps out.");
  }
}

sub escapefinisher{
  my($w1,$w2,$size,$text);
  my(@texts) = ('NO!! w1 escapes the fin!!!',
                'w1 breaks away before the fin was completed!!');

  $w1 = shift(@_);
  $w2 = shift(@_);

  $size = @texts;
  $text = $texts[int(rand($size))];

  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  $text =~ s/w2/$roster{$w2}[$c_name]/gi;
  $text =~ s/fin/$roster{$w2}[$c_move]/gi;
  push(@match,$text);
}

sub comeback{
  my($w1,$size,$text);
  my(@texts) = ('w1 has managed to get up.',
                'Somehow w1 is up!',
                'w1 is back to his feet.',
                'w1 is making a comeback after that!');
  $w1 = shift(@_);

  $size = @texts;
  $text = $texts[int(rand($size))];
  $text =~ s/w1/$roster{$w1}[$c_name]/gi;
  push(@match,$text);
}
1;