#!/usr/bin/perl
push(@INC,"D:/inetpub/hosted/geeksoft.com/fed/");
require('gfed.pl');
require('matches.pl');

use CGI;
$cgi = new CGI;

if($ARGV[0] eq ''){
  error("leagueID not specified");
}

$leagueid = $ARGV[0];
openleague($leagueid);

$login = $cgi->param('login');
$pass = $cgi->param('pass');

if($login eq 'admin' and $roster{'admin'}[$l_pass] eq encrypt($pass)){
  if($ARGV[1] eq 'setup'){
    printsetup();
  }
  if($ARGV[1] eq 'sim'){
    printedit();
  }
  if($ARGV[1] eq 'preview'){
    printpreview();
  }
  if($ARGV[1] eq 'submit'){
    $results = $cgi->param('results');
    @winners = $cgi->param('winners');
   
    foreach $winner (@winners){
      $roster{$winner}[$c_wins]++;
      $roster{$winner}[$c_points]+=2;
    }
  
    @losers = $cgi->param('losers');
    foreach $loser (@losers){
      $roster{$loser}[$c_losses]++;
    }

    $results =~ s/\|/<br>\r\n/g;
    $results =~ s/&qt;/"/g;
    $results =~ s/&gt;/>/g;
    $results =~ s/&lt;/</g;
    open(FILE,">".$file_path."$leagueid.card");
    print FILE $results;
    close(FILE);
    @keys = keys(%roster);
    foreach $key (@keys){
      if($key ne 'admin'){
        $roster{$key}[$c_hasopp] = 0;
        $roster{$key}[$c_challenges] = '';
      }
    }
    saveleague($leagueid);
    printadmin();
  }
}else{
  error("You do not have access to simulate the card");
  exit;
}

sub printsetup{
  my($login);

  my($font) = $roster{'admin'}[$l_fcolor];
  my($table) = $roster{'admin'}[$l_tcolor];
  my($bgcolor) = $roster{'admin'}[$l_bgcolor];
  my($link) = $roster{'admin'}[$l_lcolor];
  my($background) = $roster{'admin'}[$l_background];

printheader('');
print <<EOF;
 <TABLE WIDTH="80%" BGCOLOR="$table">
 <TR>
   <TD ALIGN="left">
   <FONT FACE="verdana, arial" SIZE="2" COLOR="$font">
   <FORM METHOD="post" ACTION="$script_path/sim.cgi?$leagueid+sim">
EOF

@logins = sort(keys(%roster));

foreach $login (@logins){
 if($roster{$login}[$c_hasopp] == 1){
  ($opplogin,$type,$title) = split(/\+/,$roster{$login}[$c_challenges]);

print <<EOF;
  <DT><INPUT TYPE=CHECKBOX NAME="matches" CHECKED VALUE="$login+$opplogin+$title">Leave this box checked to include the following match:<br>
    <DD>Titles up for grabs: $roster{$login}[$c_title] $roster{$opplogin}[$c_title]<br>
    <DD><INPUT TYPE=RADIO NAME="$login+$opplogin" CHECKED VALUE="sim">Simulate the Match<br>
    <DD><INPUT TYPE=RADIO NAME="$login+$opplogin" VALUE="$login"><B>$roster{$login}[$c_name]</B><BR>
    <DD><INPUT TYPE=RADIO NAME="$login+$opplogin" VALUE="$opplogin"><B>$roster{$opplogin}[$c_name]</B><BR>
EOF

  print "    <DD>Finish:<br>\n";
  print "    <DD><SELECT NAME=\"$login+$opplogin+finish\">\n";
  $x = 0;
  foreach $finish (@finishes){
    print "      <OPTION VALUE=$x>$finish\n";
    $x++;
  }
  print "    </SELECT>\n<p>\n";
  $roster{$opplogin}[$c_hasopp] = 0;
  $roster{$login}[$c_hasopp] = 0;
 }
}

print <<EOF;
   <CENTER>
     <INPUT TYPE="hidden" NAME="login" VALUE="admin">
     <INPUT TYPE="hidden" NAME="pass" VALUE="$pass">
     <INPUT TYPE="submit" VALUE="Simulate these Matches">
   </CENTER>
   </FORM>
   </FONT>
   </TD>
 </TR>
 </TABLE>
EOF
}

sub printedit{
  my($login);

  my($font) = $roster{'admin'}[$l_fcolor];
  my($table) = $roster{'admin'}[$l_tcolor];
  my($bgcolor) = $roster{'admin'}[$l_bgcolor];
  my($link) = $roster{'admin'}[$l_lcolor];
  my($background) = $roster{'admin'}[$l_background];

printheader('');
print <<EOF;
 <TABLE WIDTH="80%" BGCOLOR="$table">
 <TR>
   <TD ALIGN="left">
   <FONT FACE="verdana, arial" SIZE="2" COLOR="$font">
   <FORM METHOD="post" ACTION="$script_path/sim.cgi?$leagueid+preview">
   <CENTER>
   <INPUT TYPE="radio" CHECKED NAME="format" VALUE="auto">Auto Format <INPUT TYPE="radio" NAME="format" VALUE="html">Use <b>HTML</b><br>
   <TEXTAREA NAME="results" ROWS=20 COLS=50>
$roster{'admin'}[$l_event]

EOF
@matches = $cgi->param('matches');

foreach $match (@matches){
  ($w1,$w2,$title) = split(/\+/,$match);
  $winner = $cgi->param("$w1+$w2");
  $gimmick = $cgi->param("$w1+$w2+gimmick");
  $finish = $cgi->param("$w1+$w2+finish");
  simmatch($w1,$w2,$gimmick,$winner,$finish);
}

print <<EOF;
</TEXTAREA><BR>
   <INPUT TYPE="hidden" NAME="login" VALUE="admin">
EOF


foreach $winner (@winners){
  print "<INPUT TYPE=\"hidden\" name=\"winners\" value=\"$winner\">\n";
}
foreach $loser (@losers){
  print "<INPUT TYPE=\"hidden\" name=\"losers\" value=\"$loser\">\n";
}

print <<EOF;
   <INPUT TYPE="hidden" NAME="pass" VALUE="$pass">
   <INPUT TYPE="submit" VALUE="Preview the results"><BR>
   </CENTER>
   </FORM>
   </FONT>
   </TD>
 </TR>
 </TABLE>
</CENTER>
</BODY>
</HTML>
EOF
}

sub printpreview{
  my($login);
  $results = $cgi->param('results');
  @winners = $cgi->param('winners');
  @losers = $cgi->param('losers');
  my($font) = $roster{'admin'}[$l_fcolor];
  my($table) = $roster{'admin'}[$l_tcolor];
  my($bgcolor) = $roster{'admin'}[$l_bgcolor];
  my($link) = $roster{'admin'}[$l_lcolor];
  my($background) = $roster{'admin'}[$l_background];
  $results =~ s/\|/ /g;
  $format = $cgi->param('format');
  if($format eq 'auto'){
    $results =~ s/\r\n/<br>\r\n/g;
  }

printheader('');
print <<EOF;
 <TABLE WIDTH="80%" BGCOLOR="$table">
 <TR>
   <TD ALIGN="left">
   <FONT FACE="verdana, arial" SIZE="2" COLOR="$font"> 
   $results

   <FORM METHOD="post" ACTION="$script_path/sim.cgi?$leagueid+submit">
   <INPUT TYPE="hidden" NAME="login" VALUE="admin">
EOF
   $results =~ s/<br>\r\n/|/g;
   $results =~ s/"/&qt;/g;
   $results =~ s/>/&gt;/g;
   $results =~ s/</&lt;/g;
print <<EOF;
   <INPUT TYPE="hidden" NAME="results" VALUE="$results">
EOF

foreach $winner (@winners){
  print "<INPUT TYPE=\"hidden\" name=\"winners\" value=\"$winner\">\n";
}
foreach $loser (@losers){
  print "<INPUT TYPE=\"hidden\" name=\"losers\" value=\"$loser\">\n";
}

print <<EOF;
   <INPUT TYPE="hidden" NAME="pass" VALUE="$pass">
   <CENTER>
   <INPUT TYPE="submit" VALUE="Submit these results"><BR>
   </CENTER>
   </FORM>
   </FONT>
 </TR>
 </TABLE>
</CENTER>
</BODY>
</HTML>
EOF
}